import os, re

BANNED = [r'\bR\b', r'\bX\b', 'Φ(']  # Use F,S,T,C,𝓑; map X->T and Φ(op)->C∘T(op)
def scan_text(path):
    try:
        with open(path, 'r', encoding='utf-8', errors='ignore') as f:
            return f.read()
    except Exception:
        return ''

def test_no_banned_symbols():
    for root, _, files in os.walk('.'):
        for fn in files:
            if fn.endswith(('.py', '.md', '.txt')):
                txt = scan_text(os.path.join(root, fn))
                for pat in BANNED:
                    assert re.search(pat, txt) is None, f'Banned symbol {pat} found in {fn}'
